﻿#clear the workspace
rm(list = ls())


#install.packages('epiDisplay')
library(epiDisplay)
#install.packages('tidyr')
library(tidyr)
#install.packages('ggplot2')
library(ggplot2)
#install.packages('dplyr')
library(dplyr)




#set the working directory
setwd("~/Desktop/R")


#adhere to the sum-to-zero convention for effect weights
options(contrasts=c("contr.sum","contr.poly"))


# read the data from a csv file
carbon1<-read.csv("carbon1.csv")


# show the variable names and the first few rows of values
head(carbon1)


#create string version of framing column
carbon1$frame <- factor(carbon1$frame1_offset1,
        levels = c(1, -1),
        labels = c("Offset","Tax"))


carbon1$poli <- factor(carbon1$political_affiliation,
        levels = c(-1, 0, 1),
        labels = c("Democrat", "Independent", "Republican"))


#check the new columns and make sure everything looks ok
head(carbon1)